<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Apartment extends Model 
{

    protected $table = 'apartments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'door_number', 'address', 'block');

    public function flats()
    {
        return $this->hasMany('App\Models\Flat', 'id', 'apartment_id');
    }

}